/*jshint esversion: 6 */

// Cycle Layers behavior

define(
  function () {
	"use strict";
      
    // var log = console.logToUser;
	  
	var kStart_Immediately = 0,
		kStart_WaitForTrigger = 1,
		/* note: there were previously kStart_WaitForTriggerC = 1 and kStart_WaitForTriggerCustom = 2, both of which are now treated the same as kStart_WaitForTrigger */
		
		kCycle_Continuously = 0,
		kCycle_Once = 1,
		kCycle_OnceAndHoldOnEnd_OBSOLETE = 2,	// only found in old projects (Preview 1 & 2)
		
		kContinueWhen_Triggered = 0,
		kContinueWhen_Untriggered = 1;
	
	function resetCycle (self) {
		// optional nowShowingIndex -- cache of which layer has been triggered to show most recently
		self.activeLayerIndex = 0;			// index to show at start of next onAnimate
		self.idleCount = 0;
		self.bTriggeredDuringIdle = false;
		self.bReversePhase = false;
		self.bDeactivateAtCycleEnd = false;
		self.bPaused = false;
		self.bPreviouslyTriggered = true;	// to allow pause on first frame, assume already triggered, so you need another
											//	triggering to unpause it
	}
	  
	function resetAll (self) {
		//console.logToUser("resetAll");
		resetCycle(self);
		self.triggeredByRealTrigger = false;		// were we triggered originally and now the trigger is gone but we haven't finished
		self.realTriggerPriority = 0;
		self.bActive = false;
	}
	
	function shouldStartImmediately (args) {
		var bStartImmediately = false;
		
		switch (args.getParam("startWhen")) {
			case kStart_Immediately:
				bStartImmediately = true;
				break;
		}
		
		return bStartImmediately;
	}
	
	// handles obsolete value from old project
	function getCycleParam (args) {
		var v = args.getParam("cycle");
		if (v === kCycle_OnceAndHoldOnEnd_OBSOLETE) {
			v = kCycle_Once;
		}
		return v;
	}
	
	function immediateAndContinuous (args) {
		return shouldStartImmediately(args) &&
				(getCycleParam(args) === kCycle_Continuously);
	}
	
	// handle Immediately/Once case, which is sort of useless
	function immediateAndStillFirstCycle (self, args) {
		return self.bFirstCycle &&
				shouldStartImmediately(args) &&
				(getCycleParam(args) === kCycle_Once);
	}
	
	// returns layer that was triggered
	function showOnlyLayer(aLayers, layerIndexToShow, bReverseOrder) {
		
		var i = bReverseOrder ?
					(aLayers.length - 1 - layerIndexToShow) :
					layerIndexToShow,
			layerToTrigger = aLayers[i];
		
		layerToTrigger.trigger();	// will show this layer, and also trigger any nested Cycle Layers
		
		return layerToTrigger;
	}

	  
	function pauseOnLayer (aPauseLayers, layer)
	{
		var bPause = false;
		
		aPauseLayers.forEach(function (lay) {
			if (lay === layer) { bPause = true;}
		});
		
		return bPause;
	}
	  
	
	// IOW, we need to be called again (at least once) to get to the end of the cycle
	function somethingNeedsFinishing (bLastIdle, nowShowingLayerIndex, lastIndexPlusOne, bPingPong, bReversePhase, bHasPauseLayers)
  	{
		if (!bLastIdle) {
			return true;	// if we're not done idling, we're not done
		}
		
		if (bPingPong) {
			if (bHasPauseLayers) {
				// return true if in forward phase or haven't finished the reverse phase yet
				return (!bReversePhase || nowShowingLayerIndex !== 0);
			} else {
				return (nowShowingLayerIndex !== 0);
			}
		} else {
			return (nowShowingLayerIndex !== lastIndexPlusOne-1);
		}
  	}
	
	
	// meaning if the user released the trigger before the next onAnimate
	function ifUntriggeredWouldStillShowAFrame (bFinishCycle, bLastIdle, nowShowingLayerIndex, lastIndexPlusOne, bPingPong, bReversePhase, bHasPauseLayers)
	{
		// generally true when bFinishCycle is true, except if we happen to have just shown the very first layer when in pingpong mode
		//	(because going backwards upon release would show nothing), or the very last layer when not in pingpoing mode
		
		if (!bFinishCycle) return false;	// never holds the door open if this is off
		
		return somethingNeedsFinishing(bLastIdle, nowShowingLayerIndex, lastIndexPlusOne, bPingPong, bReversePhase, bHasPauseLayers);
	}

	return {
		about:			"Cycle Layers, (c) 2015.",
		description:	"$$$/animal/Behavior/CycleLayers/Desc=Steps through all layers in a puppet and shows each, one-by-one",
		uiName:  		"$$$/animal/Behavior/CycleLayers/UIName=Cycle Layers",
		defaultArmedForRecordOn: true,
		defaultHideInTrackItemProperties: true,
		
		defineTags : function () {
			return {
				aTags: [
					{
						id: "Adobe.CycleLayers.Pause",
						artMatches: ["cycle pause"],
						uiName: "$$$/animal/Behavior/CycleLayers/TagName/CyclePause=Cycle Pause",
						tagType: "layertag"
					}
				]
			};
		},

		defineParams : function () {
			return [
				{ id: "startWhen", type: "enum", uiName: "$$$/animal/Behavior/CycleLayers/Parameter/startWhen=Start", dephault: kStart_WaitForTrigger,
					items: [
								{ id: kStart_WaitForTrigger, 		uiName: "$$$/animal/Behavior/CycleLayers/Parameter/startWhen/WhenTriggered=When Triggered" },
								{ id: kStart_Immediately, 			uiName: "$$$/animal/Behavior/CycleLayers/Parameter/startWhen/startImmediately=Immediately" },
						   ],
					uiToolTip: "$$$/animal/behavior/cyclelayers/Parameter/startwhen/tooltip=Choose between starting immediately or waiting for a specific triggering key press assigned to this puppet or one of its parents"
				},
				{ id: "reverseOrder", type: "enum", uiName: "$$$/animal/Behavior/CycleLayers/Parameter/layerorder=Layer Order", dephault: 0,
					items: [
								{ id: 0,	uiName: "$$$/animal/Behavior/CycleLayers/Parameter/layeroder/TopToBottom=Top to Bottom" },
								{ id: 1,	uiName: "$$$/animal/Behavior/CycleLayers/Parameter/layeroder/BottomToTop=Bottom to Top" }
						   ],
				 	uiToolTip: "$$$/animal/Behavior/CycleLayers/Parameter/layerorder/tooltip=Determines the sequential order of the animated layers"
				},
				{ id: "frameCount", type: "slider", uiName: "$$$/animal/Behavior/CycleLayers/Parameter/frameCount=Advance Every",
				 	uiUnits: "$$$/animal/behavior/CycleLayers/parameter/AdvanceEvery/units/frames=frames", min: 0, max: 1000, dephault: 1,
					uiToolTip: "$$$/animal/behavior/cyclelayers/Parameter/framecount/tooltip=Affects playback speed; larger values cycle more slowly. To ^[animate on ones^], set to 1."
				},
				{ id: "cycle", type: "enum", uiName: "$$$/animal/Behavior/CycleLayers/Parameter/cycle=Cycle", dephault: kCycle_Once,
					items: [
								{ id: kCycle_Once,				uiName: "$$$/animal/Behavior/CycleLayers/Parameter/cycle/Once=Once" },
								{ id: kCycle_Continuously,		uiName: "$$$/animal/Behavior/CycleLayers/Parameter/cycle/Continuously=Continuously" }
						   ],
				 	uiToolTip: "$$$/animal/Behavior/CycleLayers/Parameter/cycle/tooltip=When triggered, cycle once or continuously while the trigger key is held down"
				},
				{ id: "pingPong", type: "checkbox", uiName: "$$$/animal/Behavior/CycleLayers/Parameter/ForwardReverse=Forward and Reverse", dephault: false,
					uiToolTip: "$$$/animal/Behavior/CycleLayers/Parameter/ForwardReverse/tooltip=Play layers in reverse after playing them forward; releasing the trigger key starts reversing immediately, unless Cycle Pause tag is used on one more layers"
				},
				{ id: "holdOnLastFrame", type: "checkbox", uiName: "$$$/animal/Behavior/CycleLayers/Parameter/HoldOnLastLayer=Hold on Last Layer", dephault: false,
					uiToolTip: "$$$/animal/Behavior/CycleLayers/Parameter/HoldOnLastFrame/tootip=Last layer stays visible until the trigger key is released"
				},
				{ id: "finishCycle", type: "enum", uiName: "$$$/animal/Behavior/CycleLayers/Parameter/OnTriggerEnd=On Trigger End", dephault: 1,
					items: [	
								{ id: 1,		uiName: "$$$/animal/Behavior/CycleLayers/Parameter/OnTriggerEnd/LetCycleFinish=Let Cycle Finish" },
								{ id: 0,		uiName: "$$$/animal/Behavior/CycleLayers/Parameter/OnTriggerEnd/StopImmediately=Stop Immediately" },
						   ],
					uiToolTip: "$$$/animal/Behavior/CycleLayers/Parameter/OnTriggerEnd/tooltip=Controls response to releasing the trigger key: either reset right away or let the cycle finish, including any reverse portion"
				},
				{ id: "pauseFrames", type: "layer", uiName: "$$$/animal/Behavior/CycleLayers/Parameter/PauseFrames=Pause-Layers",
				 	dephault: { match: "//Adobe.CycleLayers.Pause"},
					uiToolTip: "$$$/animal/Behavior/CycleLayers/Parameter/PauseFrames/tooltip=Use Cycle Pause tag to pause on one or more layers in the cycle"
				},
				{
					id: "continueWhen", type: "enum",
				 	uiName: "$$$/animal/Behavior/CycleLayers/Parameter/ContinueWhen=Continue After Pause",
					items: [	
							{ id: kContinueWhen_Triggered, uiName: "$$$/animal/Behavior/CycleLayers/Parameter/ContinueAfterPause/WhenTriggered=When Triggered" },
							{ id: kContinueWhen_Untriggered, uiName: "$$$/animal/Behavior/CycleLayers/Parameter/ContinueAfterPause/WhenUntriggered=When Trigger Released" },
						   ],
				 	dephault: kContinueWhen_Triggered,
					uiToolTip: "$$$/animal/Behavior/CycleLayers/Parameter/ContinueWhen/tooltip=Choose how to continue after pausing on Cycle-Pause-tagged layers"
				},
				{
					id: "ignorePauseOnTrigger", type: "checkbox",
				 	uiName: "Ignore Pause-Layers If Already Triggered",
				 	dephault: false,
					hidden: true,	// ignore=true was old (Beta 5) behavior; hidden because we're hoping we don't need to support it
					uiToolTip: "When enabled, holding down the trigger prevents Pause-Layers from pausing",
				},
			];
		},

		onCreateBackStageBehavior : function (/*self*/) {
			return { order: 2.0, importance : 0.0 };	// must come after anything that can trigger() so it can be triggered; TODO: make this automatic somehow
		},

		onCreateStageBehavior : function (self, args) {
			resetAll(self);
			self.bTriggerPreviouslyDown = false;
			self.bFirstCycle = true;
			
			var bHideSiblings = true, aLayers = [];
			args.stageLayer.forEachDirectChildLayer(function (lay) {
				aLayers.push(lay);
				lay.setTriggerable(bHideSiblings);
			});
			
			// note: this array holds onto sdkLayers in onCreateStageBehavior for reuse in onAnimate
			//	will want to revisit if we want Cycle Layers to support dynamically created layers
			self.aLayers = aLayers;
			
			self.aPauseLayers = args.getStaticParam("pauseFrames");
		},

		onAnimate : function (self, args) {
			//console.logToUser(`onAnimate CycleLayers, time = ${args.t + args.globalRehearseTime}`);
			var getParam = args.getParam.bind(args),
				bTrigger = false, bActualTrigger = false,
				bImmediateStart = (getParam("startWhen") === kStart_Immediately),
				cycle = getCycleParam(args),
				bHoldOnLast = getParam("holdOnLastFrame") || (getParam("cycle") === kCycle_OnceAndHoldOnEnd_OBSOLETE), // using raw "cycle" access
				bHasPauseLayers = self.aPauseLayers.length > 0,
				bPingPong = getParam("pingPong"),
				bFinishCycle = getParam("finishCycle") && !bImmediateStart,	// see DVACH-2073 for exclusion of kStart_Immediately
				bIgnorePauseOnTrigger = getParam("ignorePauseOnTrigger"),
				bAlwaysPauseAtLeastOneFrame = !bIgnorePauseOnTrigger,
				bWasPaused = self.bPaused,
				bContinueWhenTriggered = (getParam("continueWhen") === kContinueWhen_Triggered),
				triggeringLayer0 = args.getTriggeringLayer(),
                triggerType = args.getTriggeringType(),
				lastIndexPlusOne = self.aLayers.length;
			
			if (cycle !== kCycle_Once) {
				self.bFirstCycle = true;	// not really true, but makes "Once" actually show a result (otherwise switching
			}								// from Continuous to Once would show nothing)
			
			bActualTrigger = (triggerType === "realTrigger" || triggerType === "behaviorTrigger");       // not a re-trigger at our own request
			bTrigger = bActualTrigger || shouldStartImmediately(args);
			
			//log(`triggerType = ${triggerType}, bActualTrigger = ${bActualTrigger}`);
			
			if (self.bTriggerPreviouslyDown) {
				if (!bTrigger) { // trigger just released
					//log("trigger just released");
					self.bTriggerPreviouslyDown = false;
					if (self.bActive) {
						// any pause-layers means reversal only happens at end, not on trigger-up
						if (bPingPong && !bHasPauseLayers) {
							self.bReversePhase = true;
						}
						if (bFinishCycle && somethingNeedsFinishing(self.bLastIdleNowShowing, self.nowShowingIndex, lastIndexPlusOne, bPingPong, self.bReversePhase, bHasPauseLayers)) {
							self.bDeactivateAtCycleEnd = true;
						} else {
							resetAll(self);
						}
					} // else cycle already finished while trigger was still being held down
				}
			} else {
				if (bTrigger) { // trigger just pulled
					//log("trigger just pulled");
					self.bTriggerPreviouslyDown = true;
					if (self.bActive && self.bPaused) {
						self.bPaused = false;
					} else if (self.bActive && self.bDeactivateAtCycleEnd && self.bReversePhase && !bHasPauseLayers) {
						// special case to allow pressing the trigger during the reverse phase to turn around
						//	and continue from the current frame going forward; doesn't happen if there are any pause-layers
						self.bReversePhase = false;
						self.bDeactivateAtCycleEnd = false;
					} else {
						// note: here we may still be finishing a forward cycle (self.bActive && self.bDeactivateAtCycleEnd)
						//	but we still want to start from frame one -- this means a trigger can interrupt the finishing cycle
						//	(unlike the bReversePhase clause just above, where it just starts going forward again)
						resetAll(self);
						self.bActive = true;
					}
					if (bActualTrigger) {
						self.triggeredByRealTrigger = triggerType; // can't sustain unless actually triggered, so remember that here
						// TODO: factor into sdkLayer.getTriggerMutexPriority()
						self.realTriggerPriority = triggeringLayer0.getParentLayer().privateLayer.triggerMutexPriority;
						//console.logToUser(`pri ${self.realTriggerPriority} read by Cycle Layers`);
					}
				}
			}
			
			if (self.bDeactivateAtCycleEnd && self.triggeredByRealTrigger === "behaviorTrigger") {
				// keep "foot in door" -- hold down original trigger (old style: for this frame)
                //  TODO: once all triggering goes through trigger groups (even ones not visible to user),
                //      we can remove all the "behaviorTrigger" pathways
				//console.logToUser("SUSTAINING a behaviorTrigger");

				args.sustainTrigger(self.realTriggerPriority);	// sustain at same priority as original trigger
			}
			
			// alternatively, we could remove the startWhen param, and always start immediately if there is no
			// 	triggerable parent? No, then you wouldn't be able to make two sibling cycle layers with one
			//	continuously cycling (e.g. waves) and the other starting its cycle only when triggered
			var bRunUntriggered = immediateAndContinuous(args) || immediateAndStillFirstCycle(self, args);
			
			if (self.bActive || bRunUntriggered) {				
				// first, show the requested layer
				//console.logToUser(`self.activeLayerIndex = ${self.activeLayerIndex}`);
				var triggeredLayer = showOnlyLayer(self.aLayers, self.activeLayerIndex, getParam("reverseOrder"));
				
				self.nowShowingIndex = self.activeLayerIndex;

				// second, calculate the next layer to show (for next time slice)
				if (++self.idleCount >= getParam("frameCount")) {
					var bTriggered = (bActualTrigger || self.bTriggeredDuringIdle),
						bPreventPausing = bIgnorePauseOnTrigger && bTriggered;	// ignores bContinueWhenTriggered

					if (!bContinueWhenTriggered) {
						bTriggered = !bTriggered;	// continue when _un_triggered
					}
					
					var bNewlyUnpaused = !self.bPreviouslyTriggered && bTriggered;
					
					if (bAlwaysPauseAtLeastOneFrame && bNewlyUnpaused && !bWasPaused) {
						// ignore unpausing trigger if we haven't paused on a pause-frame yet
						//	(fixes pausing on frame 2 -- see DVACH-1347)
						bNewlyUnpaused = false;
					}
					
					self.bPreviouslyTriggered = bTriggered;
										
					self.idleCount = 0;
					if (bHasPauseLayers &&
							!bPreventPausing && pauseOnLayer(self.aPauseLayers, triggeredLayer) &&
					    	!bNewlyUnpaused) {
						self.bPaused = true;	// prevent restarting on next trigger down
						// this is similar to bDeactivateAtCycleEnd (which will also be set here usually),
						//	but that mode can be restarted with a new trigger and this one can't
					} else {
						if (self.bReversePhase) {
							--self.activeLayerIndex;
						} else {
							++self.activeLayerIndex;
						}
					}
					self.bTriggeredDuringIdle = false;
				} else {
					// idling (showing same frame again)
					self.bPaused = bWasPaused;	// keeps bWasPaused accurate across idles
					if (bActualTrigger) {
						self.bTriggeredDuringIdle = true;	// remember so that we don't lose the keydown
					}
				}
				self.bLastIdleNowShowing = (self.idleCount === 0);
				
				if (self.activeLayerIndex === lastIndexPlusOne) {
					// ran off end, check on holding/pingpong
					var bHolding = bHoldOnLast && (bTrigger || bImmediateStart); // only honor holdOnLast if trigger down or no trigger used
					
					if (bHolding || bPingPong) {
						--self.activeLayerIndex; // stop it from running off the end
					}
					if (!bHolding && bPingPong) {
						self.bReversePhase = true;
						--self.activeLayerIndex; // skip last frame in reverse phase (to prevent it showing twice)
					}
				}
								
				var bBeforeFirst = (self.activeLayerIndex < 0);
				if (self.activeLayerIndex >= lastIndexPlusOne || bBeforeFirst) {
					// either ran off end when going forward (with no hold), or start when reversing
					if (cycle === kCycle_Once || self.bDeactivateAtCycleEnd) {
						self.bActive = false;
					}
					resetCycle(self);
					if (bBeforeFirst) {
						++self.activeLayerIndex; // skip first frame when looping in pingpong mode (to prevent it showing twice)
					}
					self.bFirstCycle = false;
				}
				
				//console.logToUser(`self.bActive = ${self.bActive}, ${self.triggeredByRealTrigger === "realTrigger"}, self.triggeredByRealTrigger = ${self.triggeredByRealTrigger}, triggerType = ${triggerType}`);
				if (self.triggeredByRealTrigger === "realTrigger") {
					if (self.bActive && ifUntriggeredWouldStillShowAFrame(bFinishCycle, self.bLastIdleNowShowing, self.nowShowingIndex, lastIndexPlusOne, bPingPong, self.bReversePhase, bHasPauseLayers)) {
						//console.logToUser("RETRIGGERING a realTrigger pri="+self.realTriggerPriority);
						args.retriggerOnNextFrame(self.realTriggerPriority);
					} else {
						//console.logToUser("not retriggering");
					}
				}

			} else {
				// not active; nothing to do -- all the layers will be hidden because they're triggerable
				delete self.nowShowingIndex;
			}
		}

	}; // end of object being returned
});
